#ifndef __PROFIBUS_APM_ERROR_H
#define __PROFIBUS_APM_ERROR_H

/////////////////////////////////////////////////////////////////////////////////////
// PROFIBUS Master APM Packet Status codes
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_PROFIBUS_APM_COMMAND_INVALID
//
// MessageText:
//
//  Invalid command received.
//
#define TLR_E_PROFIBUS_APM_COMMAND_INVALID ((TLR_RESULT)0xC0390001L)

//
// MessageId: TLR_E_PROFIBUS_APM_COMMAND_ALREADY_IN_RQUEST
//
// MessageText:
//
//  Command already in request.
//
#define TLR_E_PROFIBUS_APM_COMMAND_ALREADY_IN_RQUEST ((TLR_RESULT)0xC0390002L)

//
// MessageId: TLR_E_PROFIBUS_APM_TIO_RESET_W_MODE_STOP
//
// MessageText:
//
//  Timeout while stopping PROFIBUS.
//
#define TLR_E_PROFIBUS_APM_TIO_RESET_W_MODE_STOP ((TLR_RESULT)0xC0390003L)

//
// MessageId: TLR_E_PROFIBUS_APM_TIO_RESET_W_INIT_FSPMM
//
// MessageText:
//
//  Timeout while resetting PROFIBUS.
//
#define TLR_E_PROFIBUS_APM_TIO_RESET_W_INIT_FSPMM ((TLR_RESULT)0xC0390004L)

//
// MessageId: TLR_E_PROFIBUS_APM_NON_EXCHANGE_SLAVE
//
// MessageText:
//
//  No data exchange with at least one slave.
//
#define TLR_E_PROFIBUS_APM_NON_EXCHANGE_SLAVE ((TLR_RESULT)0xC0390005L)

//
// MessageId: TLR_E_PROFIBUS_APM_NON_EXCHANGE_ALL
//
// MessageText:
//
//  No slave in data exchange.
//
#define TLR_E_PROFIBUS_APM_NON_EXCHANGE_ALL ((TLR_RESULT)0xC0390006L)

//
// MessageId: TLR_E_PROFIBUS_APM_CONFIG_LOCK
//
// MessageText:
//
//  Configuration locked .
//
#define TLR_E_PROFIBUS_APM_CONFIG_LOCK   ((TLR_RESULT)0xC0390007L)

//
// MessageId: TLR_E_PROFIBUS_APM_CONFIG_VIA_DBM
//
// MessageText:
//
//  Already configured via data base.
//
#define TLR_E_PROFIBUS_APM_CONFIG_VIA_DBM ((TLR_RESULT)0xC0390008L)

//
// MessageId: TLR_E_PROFIBUS_APM_ALREADY_CONFIGURED
//
// MessageText:
//
//  Already configured.
//
#define TLR_E_PROFIBUS_APM_ALREADY_CONFIGURED ((TLR_RESULT)0xC0390009L)

//
// MessageId: TLR_E_PROFIBUS_APM_CHANNEL_INIT_IN_PROGRESS
//
// MessageText:
//
//  Channel initialization in progress.
//
#define TLR_E_PROFIBUS_APM_CHANNEL_INIT_IN_PROGRESS ((TLR_RESULT)0xC039000AL)

//
// MessageId: TLR_E_PROFIBUS_APM_CHANNEL_INIT_FAILED
//
// MessageText:
//
//  Channel initialization failed.
//
#define TLR_E_PROFIBUS_APM_CHANNEL_INIT_FAILED ((TLR_RESULT)0xC039000BL)




#endif  //__PROFIBUS_APM_ERROR_H

